% This function calculate the pearson correlation between MSI data and each
% cluster, so we can identify which masses are highly correlated with each
% cluster

function correlation_Array = Correlate_MZ_Clusters(Clusters, DataCube,S,index_NoBackground)

% Number of clusters
N = length(unique(Clusters));
N_MS = size(DataCube,2);


for Cluster_ID=1:N
    C = Clusters == Cluster_ID;
    [imgK color_arr] = Visualize_combined_ClusteredImage(C,S,index_NoBackground);
    Binary_Cluster_Vector = imgK(:);
    for i=1:N_MS
        MS = DataCube(:,i);
        R = corrcoef(Binary_Cluster_Vector,MS);
        correlation_Array(Cluster_ID,i) = R(1,2);
    end
end